/* Plugin generated by AMXX-Studio */

#include <amxmodx>
#include <amxmisc>
#include <engine>
#include <fakemeta>



#define PLUGIN "DeathBones"
#define VERSION "1.1.0"
#define AUTHOR "mogel"



#define BONE_ALPHA_TASK_BASIS 1000
new pcv_deathmatch	// Deathmatch-Support
new pcv_bonestime	// anzeigen der Bones



#define ALPHA EV_INT_iuser4
#define PLAYER EV_INT_iuser3



public plugin_init() {
	register_plugin(PLUGIN, VERSION, AUTHOR)

	register_message(get_user_msgid("DeathMsg"), "Event_Death")
	register_event("HLTV", "Event_FreezeTime", "a", "1=0", "2=0")
	
	register_cvar("DeathBones", VERSION, FCVAR_SERVER | FCVAR_SPONLY | FCVAR_UNLOGGED)
	
	pcv_deathmatch = register_cvar("db_deathmatch", "0")	// per default kein DM-Support
	pcv_bonestime = register_cvar("db_bonestime", "30.0")	// 30 Sekunden
}
public plugin_precache() {
	precache_model("models/skeleton.mdl")
}
public Event_FreezeTime() {
	new players[32], count
	get_players(players, count, "h")
	for(new i = 0; i < count; i++)
	{
		new player = players[i]
		
		// Render zurck setzen
		set_pev(player, pev_renderfx, kRenderFxNone)
		set_pev(player, pev_rendercolor, 255,255,255)
		set_pev(player, pev_rendermode, kRenderNormal)
		set_pev(player, pev_renderamt, 0.0)
	}
	
	remove_entity_name("deathbones")
}
public Event_Death() {
	new player = get_msg_arg_int(2)
	
	new Float:bones[3]
	new Float:angle[3]
	
	entity_get_vector(player, EV_VEC_origin, bones)
	entity_get_vector(player, EV_VEC_angles, angle)
	bones[2] -= 32.0 // gleich nach unten setzen
	
	// Bones erstellen
	new entity = create_entity("info_target")
	entity_set_string(entity, EV_SZ_classname, "deathbones")
	entity_set_model(entity, "models/skeleton.mdl")
	entity_set_origin(entity, bones)
	entity_set_vector(entity, EV_VEC_angles, angle)

	entity_set_int(entity, EV_INT_movetype, MOVETYPE_TOSS)
	entity_set_int(entity, EV_INT_solid, SOLID_NOT)
	
	// Bones erstmal unsichtbar
	set_pev(entity, pev_renderfx, kRenderFxNone)
	set_pev(entity, pev_rendercolor, 255,255,255)
	set_pev(entity, pev_rendermode, kRenderTransAlpha)
	set_pev(entity, pev_renderamt, 0.0)

	// Spieler durch Bones wechseln
	entity_set_int(entity, PLAYER, player)		// den Bones dem Spieler zuweisen
	entity_set_int(entity, ALPHA, 0)		// aktuelles Alpha fr die Bones
	set_task(1.0, "BonesAlphaIn", entity)
}
public BonesAlphaIn(bones) {
	if (!is_valid_ent(bones)) return
	
	new alpha = entity_get_int(bones, ALPHA) + 1
	new player = entity_get_int(bones, PLAYER)
	
	// Spieler ausblenden, aber nur wenn kein DM-Modus
	if ((is_valid_ent(player)) && !get_pcvar_num(pcv_deathmatch))
	{
		set_pev(player, pev_renderfx, kRenderFxNone)
		set_pev(player, pev_rendercolor, 255,255,255)
		set_pev(player, pev_rendermode, kRenderTransAlpha)
		set_pev(player, pev_renderamt, float(256 - alpha * 16))
	}
	
	if (is_valid_ent(bones))
	{
		set_pev(bones, pev_renderfx, kRenderFxNone)
		set_pev(bones, pev_rendercolor, 255,255,255)
		set_pev(bones, pev_rendermode, kRenderTransAlpha)
		set_pev(bones, pev_renderamt, float(alpha * 16 - 1))
	}
	
	// neuen Alpha-Wert merken
	entity_set_int(bones, ALPHA, alpha)
	
	// jetzt entscheiden .. .weiter Alpha oder liegen lassen
	if (alpha >= 16)
	{
		// wenn kein DM dann Spieler jetzt nach unten setzen
		if (!get_pcvar_num(pcv_deathmatch))
		{
			// Bones werden am Rundenanfng automatisch gelscht
			PlayerMove(player)
		} else
		{
			// im DM-Modus nach X Sekunden wieder ausblenden
			set_task(get_pcvar_float(pcv_bonestime), "BonesAlphaOut", bones)
		}
	} else
	{
		set_task(0.1, "BonesAlphaIn", bones)
	}
}
public BonesAlphaOut(bones) {
	if (!is_valid_ent(bones)) return
	
	new alpha = entity_get_int(bones, ALPHA) - 1
	
	if (is_valid_ent(bones))
	{
		set_pev(bones, pev_renderfx, kRenderFxNone)
		set_pev(bones, pev_rendercolor, 255,255,255)
		set_pev(bones, pev_rendermode, kRenderTransAlpha)
		set_pev(bones, pev_renderamt, float(alpha * 16 - 1))
	}
	
	// neuen Alpha-Wert merken
	entity_set_int(bones, ALPHA, alpha)
	
	// jetzt entscheiden .. .weiter Alpha oder killen
	if (alpha)
	{
		set_task(0.1, "BonesAlphaOut", bones)
	} else
	{
		remove_entity(bones)
	}
}
public PlayerMove(player) {
	new Float:pos[3]
	entity_get_vector(player, EV_VEC_origin, pos)
	pos[2] -= 2000.0
	entity_set_vector(player, EV_VEC_origin, pos)
}
